/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _unison_app_config_h_
#define _unison_app_config_h_


/*
 * Include yours CPU series HAL file and comment out the string with the warning message.
 * The including HAL header file can be taken from the file "main.c" which is generated by STM32CubeMX.
 */
#warning "Include an appropriate HAL header"
#include <stm32f7xx_hal.h>


/*
 * Dynamic memory heap size. Used in the file "unison_heap.c".
 */
#define MEMSIZE_HEAP 6000


/*
 * Set system timer period in ns. This time should be the same as SysTick interrupt period.
 * Used in the file "unison_kernel_start.c".
 */
#define CLOCK_TIME_PERIOD  1000000  // nanoseconds per tick - period 1ms



/*
 * This define controls output direction for functions xprintf(), xputs() and xputchar():
 *   - "0" puts messages to UART;
 *   - "1" puts messages to buffer.
 * Used in the file "unison_kernel_start.c".
 */
#define DEBUG_TO_BUF 0


#endif /* _unison_app_config_h_ */
