/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _errno_h_
#define _errno_h_

#ifdef __cplusplus
extern "C" {
#endif

/* Note that the Directory task assumes errno fits in 16-bits.
 * This does not apply to fatal errors.
 */
#define EOK                 0
#define EPERM               1
#define ENOENT              2
#define ESRCH               3
#define EINTR               4
#define EIO                 5
#define ENXIO               6
#define E2BIG               7
#define ENOEXEC             8
#define EBADF               9
#define ECHILD              10
#define EAGAIN              11
#define ENOMEM              12
#define EACCES              13
#define EFAULT              14
#define ENOTSUPPORTED       15
#define EBUSY               16
#define EEXIST              17
#define EXDEV               18
#define ENODEV              19
#define ENOTDIR             20
#define EISDIR              21
#define EINVAL              22  /* asm */
#define ENFILE              23
#define EMFILE              24
#define ENOTTY              25
#define ETXTBSY             26
#define EFBIG               27
#define ENOSPC              28
#define ESPIPE              29
#define EROFS               30
#define EMLINK              31
#define EPIPE               32
#define EDOM                33
#define ERANGE              34
#define ELOOP               35
#define EIDRM               36
#define EILSEQ              37
#define EOVERFLOW           38
#define ENODATA             39
#define ENOSR               40
#define ENOSTR              41
#define ETIME               42
#define ENOTRECOVERABLE     43
#define EOWNERDEAD          44
#define EDEADLK             45
#define ENOLCK              46
#define ECANCELED           47
#define ENOTSUP             48
#define ENOMSG              49
#define EBADMSG             50
#define ENAMETOOLONG        51
#define ENOSYS              52
#define ENOTEMPTY           53
#define EMSGSIZE            54
#define EINPROGRESS         55
#define ETIMEDOUT           56
#define EPROTO              57


/* TCP/IP errors */
#define EPROTONOSUPPORT     60
#define EPROTOTYPE          61
#define ENOBUFS             62
#define EOPNOTSUPP          63
#define EISCONN             64
#define ENOTCONN            65
#define EALREADY            66
#define EADDRINUSE          67
#define EDESTADDRREQ        68
#define EWOULDBLOCK         69
#define ENOPROTOOPT         70
#define EAFNOSUPPORT        71
#define ENETUNREACH         72
#define EADDRNOTAVAIL       73
#define EHOSTDOWN           74
#define EHOSTUNREACH        75
#define ECONNREFUSED        76
#define ENETDOWN            77
#define ECONNRESET          78
#define ECONNABORTED        79
#define ENETRESET           80
#define ETOOMANYREFS        81
#define EPFNOSUPPORT        82
#define ENOTSOCK            83


/* POSIX reserved */
#define EMULTIHOP           90
#define ENOLINK             91


/* The following are Unison specific */
#define EBADINDEX           100
#define EBADID              101
#define EBADPORT            102
#define ETHREADDIED         104     /* thread blocked on died */
#define EBADSERVERNAME      105
#define ENOSERVERFOUND      106
#define EBADUCB             107


// Error numbers for file system and other unison servers
#define EBADFSYS            110
#define ENOEXTENTS          111
#define EDQUOT              112    // POSIX reserved uses
#define ESTALE              113    // POSIX reserved uses
#define ENFSERR             114
#define ERPCFAILED          115
#define ECANTSPAWNPROCESS   116
#define ENAMLEN             119
#define EBADBLOCK           120


/* Floating point errors  offset by 100 */
#define EDOMAIN             190

// Use in servers
#define DONT_REPLY          255

extern int errno;


/* These defines are passed to kfatal */
#define FAT_HEAP            0x40000001UL
#define FAT_PRIORITY        0x40000002UL
#define FAT_NPORTS          0x40000003UL
#define FAT_DUPINDEX        0x40000004UL
#define FAT_READYQS         0x40000005UL
#define FAT_IDLE            0x40000010UL
#define FAT_ROOT            0x40000011UL
#define FAT_DIRECTORY       0x40000012UL
//#define FAT_NTHREAD       0x40000013UL
#define FAT_BRIDGE          0x40000100UL
#define FAT_MULTIPROC       0x40000101UL
#define FAT_KERNEL          0x40000200UL

extern unsigned long KFATAL;


#ifdef __cplusplus
} //extern "C" {
#endif

#endif  /* _errno_h_ */
