/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _kalloc_h_
#define _kalloc_h_

#ifdef __cplusplus
extern "C" {
#endif

/* These are the types that are passed to kalloc and kfree */
#define KA_TD       1       /* thread struct */
#define KA_STACK    2       /* thread stack */
#define KA_RD       3       /* rendezvous ports */
#define KA_QCB      4       /* posix message queue struct */
#define KA_QD       5       /* posix message queue struct */
#define KA_MSGB     6       /* posix message queue buffers */
#define KA_SEM      7       /* for sem_open */
#define KA_TIMER    8       /* timer_create */
#define KA_PT       9       /* pt_create */
#define KA_PTHRATTR 10      /* pthread_attr_init */
#define KA_DIR      11      /* dirs functions */
#define KA_PTHRMUTATTR  12  /* pthread_mutexattr_init */

/* Multiprocessor only */
#define KA_SHARED   100
#define KA_MP       101

/* Used by bridge only */
#define KA_BRIDGE   100

/* for default xputchar */
#define KA_XPUTCHAR 200

void *kalloc(int type, size_t size);
void kfree(int type, void *ptr);

#ifdef __cplusplus
} //extern "C" {
#endif

#endif /* _kalloc_h_ */
