/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _types_h_
#define _types_h_

#include <bits/wordsize.h>
#include <bits/local_lim.h>
#include <endian.h>

#ifdef __cplusplus
extern "C" {
#endif


/*  The following typedefs allow us to minimize portability problems
 *  due to the various C compilers (even for the same processor) not
 *  agreeing on the sizes of "int"s and "short int"s.
 * These types are not posix types.
 */
#if __WORDSIZE == 16
    typedef signed   char      int_8;
    typedef          short     int_16;
    typedef          long      int_32;
    typedef signed   long long int_64;
    typedef unsigned char      uint_8;
    typedef unsigned short     uint_16;
    typedef unsigned long      uint_32;
    typedef unsigned long long uint_64;

#elif __WORDSIZE == 32
    typedef signed   char      int_8;
    typedef          short     int_16;
    typedef          int       int_32;
    typedef signed   long long int_64;
    typedef unsigned char      uint_8;
    typedef unsigned short     uint_16;
    typedef unsigned int       uint_32;
    typedef unsigned long long uint_64;

#else
    #error You must define the platform bits for this port!
#endif



/*
 * These are common defines for 16bit and 32bit CPUs
 */

/* Type "long" is 32bit wide */
#define __have_long32 1

/* Type "long long" is 64bit wide */
#define __have_longlong64 1

/* Use 64bit type */
#define __int64_t_defined



/*
 * For tcp-server
 */
#define u_int8_t    uint_8
#define u_int16_t   uint_16
#define u_int32_t   uint_32
#define u_int64_t   uint_64
typedef uint_32     u_quad_t;   /* quads */
typedef int_32      quad_t;     /* quads */

#define    NBBY    8               /* number of bits in a byte */
/*
 * From <sys/param.h>
*/
#ifndef howmany
  #define   howmany(x, y)   (((x) + ((y) - 1)) / (y))
#endif
#define    roundup(x, y)   ((((x)+((y)-1))/(y))*(y))


typedef unsigned char   uchar;
typedef unsigned short  ushort;
typedef unsigned int    uint;
typedef unsigned long   ulong;
typedef unsigned char   u_char;
typedef unsigned short  u_short;
typedef unsigned int    u_int;
typedef unsigned long   u_long;

typedef signed long     off_t;         //Used for file sizes, shall be signed integer types.
typedef int             pid_t;         //Used for process IDs and process group IDs, shall be signed integer types
typedef uint_16         uid_t;         //user id, shall be integer types.
typedef uint_16         gid_t;         //shall be integer types
typedef uint_32         id_t;          //Used as a general identifier; can be used to contain at least a pid_t, uid_t, or gid_t.

typedef uint/*_32*/ opaque;
typedef void *NetAddr;
typedef uint_32 BitMask;

typedef int_32          _intptr_t;
typedef uint_32         _uintptr_t;

#define ADDR_TO_NET(x)    addr_to_net(x)
#define NET_TO_ADDR(x)    net_to_addr(x)

#define addr_to_net(X)  (NetAddr)(X)
#define net_to_addr(X)  (NetAddr)(X)

#if __WORDSIZE == 16
    typedef uint_16 Status;
#elif __WORDSIZE == 32
    typedef uint_32 Status;
#else
    #error Select 'Status' size!
#endif

typedef int             mode_t;       //mode_t shall be an integer type.
typedef char *          caddr_t;
typedef long            time_t;       //Used for time in seconds, shall be integer or real-floating types.
typedef uint_32         clock_t;      //shall be integer or real-floating types.
typedef opaque          clockid_t;
typedef opaque          timer_t;      //Used for timer ID returned by timer_create(),

typedef u_long          useconds_t;
typedef int_32          suseconds_t;  //Used for time in microseconds, the widths are no greater than the width of type long

typedef int             blkcnt_t;     //shall be signed integer types.
typedef int             blksize_t;    //shall be signed integer types
typedef uint_16         dev_t;        //Used for device IDs
typedef uint_32         ino_t;        //Used for file serial numbers, shall be defined as unsigned integer types
typedef uint_16         nlink_t;      //Used for link counts, shall be integer types.

/*not defined in Unison implementation:
 * fsblkcnt_t , locale_t, fsfilcnt_t ,
 * key_t, trace_attr_t, trace_event_id_t
 * trace_event_set_t , trace_id_t
*/

#include <stddef.h>        // size_t, NULL
typedef int             ssize_t;        //ssize_t shall be signed integer types

#ifdef __cplusplus
} //extern "C" {
#endif

#endif  /* _types_h_ */
