/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef __pthread_h_
#define __pthread_h_

typedef struct {
    int priority;
#if _POSIX_THREAD_ATTR_STACKADDR > 0
    void *stackbase;
#endif
#if _POSIX_THREAD_ATTR_STACKSIZE > 0
    size_t stacksize;
#endif
    struct sched_param *sparam;
    int detachstate;
} _pthread_attr_t;

#define PTHREAD_ATTR(a)    ((_pthread_attr_t*)(a)->attrp)


typedef struct {
    int type;
} _pthread_mutexattr_t;

#define PTHREAD_MUTEXATTR(a)    ((_pthread_mutexattr_t*)(a)->attrp)


#define VALID_BARRIER(barrier)  ((unsigned int)(barrier) == (barrier)->id)
#define VALID_CONDVAR(condvar)  ((unsigned int)(condvar) == (condvar)->id)


/* Flags determining processing of cancellation.  */
// Bit set if cancellation is disabled.
#define CANCELSTATE_BIT     0U
#define CANCELSTATE_BITMASK (1U << CANCELSTATE_BIT)
// Bit set if asynchronous cancellation mode is selected.
#define CANCELTYPE_BIT      1U
#define CANCELTYPE_BITMASK  (1U << CANCELTYPE_BIT)
// Bit set if canceling has been initiated.
#define CANCELING_BIT       2U
#define CANCELING_BITMASK   (1U << CANCELING_BIT)

#define CANCEL_ENABLED_AND_CANCELING_AND_ASYNCHRONOUS(value) \
    (((value) & (CANCELSTATE_BITMASK | CANCELING_BITMASK | CANCELTYPE_BITMASK)) \
            == (CANCELING_BITMASK | CANCELTYPE_BITMASK))
#define CANCEL_ENABLED_AND_CANCELING(value) \
    (((value) & (CANCELSTATE_BITMASK | CANCELING_BITMASK)) \
            == (CANCELING_BITMASK))

void _kexit(void *ret);
void __pthread_setcanceltype(int type, int *oldtype);
#define CANCELLATION_POINT() \
    if (CANCEL_ENABLED_AND_CANCELING(_Active->cancelstatus))    \
    {                                                            \
        _kexit(PTHREAD_CANCELED);                                \
    }

#endif /* __pthread_h_ */
