/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#include <sys.h>
#include "../port/platform.h"
#include "idle.h"


pthread_t _IdleID;
size_t _IdleThreadStack = 0;
char _IdleName[IDLE_NAME_LEN] = IDLE_NAME;

/*
 * User callback function
 */
static void (*_IdleCallback)(void) = NULL;


/**
 * @addtogroup private_kernel private kernel functions
 * @{
 */


/**
 *  @brief     Change default stack size for idle thread
 *
 *  @param[in] size: stack size.
 *
 *  @retval    none.
 */
void set_IdleThread_stack(size_t size)
{
    if (size < platform_get_stack_min())
        _IdleThreadStack = platform_get_stack_min();
    else
        _IdleThreadStack = size;
}


/**
 *  @brief     Set callback function for idle thread.
 *
 *  @param[in] funk: pointer to callback function.
 *
 *  @return    none.
 */
void set_IdleThread_callback(void (*funk)(void))
{
    _IdleCallback = funk;
}


/**
 *  @brief     It should do nothing, and preferably put the machine to sleep.
 *
 *  @param[in] arg: not used.
 *
 *  @return    Always return Null.
 */
THREAD _IdleThread (void *arg)
{
    (void)arg;

    for (;;)
    {
        if (_IdleCallback != NULL)
            (*_IdleCallback)();
    }

    /*
     * Here, some of compilers can generate a warning like "statement is unreachable".
     * But without this code some of them generate a warning like "no return, in function returning non-void".
     */
    return NULL;    /* Not reachable */
}

/**
 * @} end private kernel functions group
 */
