/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _mrendez_h_
#define _mrendez_h_

#ifdef __cplusplus
extern "C" {
#endif

int mr_init(int nports);
pthread_t mr_send(void *rqst, void *rply, pthread_t id, int port,
                   const struct timespec *timeout);
pthread_t mr_receive(void *rqst, BitMask portmask, BitMask sigmask,
                      int *outport, const struct timespec *timeout);
pthread_t mr_reply(void *rply, pthread_t id);
int mr_sigpost(pthread_t id, int signum);
int mr_sigrecv(BitMask sigmask);

/* INTERRUPT_ID is returned by mr_receive when it is woken up by an
   mr_sigpost rather than a message. */
#define INTERRUPT_ID            (pthread_t)0xFFFFFFFFU

/* TIMEOUT_ID is returned by mr_receive when it is woken up by an
   mr_sigpost rather than a timeout (timer_tick). */
#define TIMEOUT_ID            (pthread_t)0xFFFFFFFEU

/* A timeout value given as FOREVER will block the task until some other
   event occurs; it will never timeout, and will never return the ETIMEOUT
   error code. To poll, pass a timespec struct will both values 0. */
#define FOREVER     ((void *)0)
#define ALLPORTS    (~((BitMask)0))
#define NOPORTS     ((BitMask)0)
#define ALLSIGS     (~((BitMask)0))
#define NOSIGS      ((BitMask)0)

/* convert a port or sigpost signal to mask for mr_receive/mr_sigrecv */
#define MR_MASK(n)  (1 << (n))

#ifdef __cplusplus
} //extern "C" {
#endif

#endif /* _mrendez_h_ */
