/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _time_h_
#define _time_h_

#if _POSIX_TIMERS > 0

#include <sys/types.h>
#include <stddef.h>
#include <signal.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Posix time.h For the stuff covered by _POSIX_TIMERS option. */

/* Note deviations from Posix: */
/* timer_getoverrun() returns -1 and does nothing else. The Posix realtime
   signals option is not implemented, and the standard allows this functions
   return value to be undefined in that case. */
/* timer_tick() is a hardware support function. The user is expected to call
   this from his interrupt service routine for a clock. It updates any timers
   on that clock. */
/* clock_init() is a hardware support function. The user is expected to call
   this from his setup code, before calling DSPexec_Start(). It only sets the
   resolution of the specified clock. */


/* IKM 2007/05: As of this writing, the only clock allowed is CLOCK_REALTIME.
   Some functions will return -1 and set errno to EINVAL if any other clock
   id is provided. clock_init() will do nothing, as there's no task running
   for errno to belong to, and timer_tick() will do nothing as it's in an
   ISR. */


struct timespec
{
    time_t tv_sec;      /* seconds */
    long tv_nsec;       /* nanoseconds */
};

struct itimerspec
{
    struct timespec it_interval;
    struct timespec it_value;
};

struct tm
{
    int tm_sec;     /* second (0-61, allows for leap seconds) */
    int tm_min;     /* minute (0-59) */
    int tm_hour;    /* hour (0-23) */
    int tm_mday;    /* day of the month (1-31) */
    int tm_mon;     /* month (0-11) */
    int tm_year;    /* years since 1900 */
    int tm_wday;    /* day of the week (0-6) */
    int tm_yday;    /* day of the year (0-365) */
    int tm_isdst;   /* non-0 if daylight savings time is in effect */
};

#define CLOCK_REALTIME      (clockid_t)0
#define CLOCK_MONOTONIC     (clockid_t)1
//Not defined in Unison
//#define CLOCK_PROCESS_CPUTIME_ID
//#define CLOCK_THREAD_CPUTIME_ID


char *asctime(const struct tm *timeptr);
char *asctime_r(const struct tm *timeptr, char *buf);
clock_t clock(void);
int clock_getcpuclockid(pid_t, clockid_t *);
int clock_getres(clockid_t clockid, struct timespec *res);
int clock_gettime(clockid_t clockid, struct timespec *tp);
int clock_nanosleep(clockid_t, int, const struct timespec *, struct timespec *);
int clock_settime(clockid_t clockid, const struct timespec *tp);
char *ctime(const time_t *timep);
char *ctime_r(const time_t *timep, char *buf);
double difftime(time_t time1, time_t time0);
struct tm *getdate(const char *buf);
struct tm *gmtime(const time_t *timep);
struct tm *gmtime_r(const time_t *timep, struct tm *p_tm);
struct tm *localtime(const time_t *timer);
struct tm *localtime_r(const time_t *timer, struct tm *result);
time_t mktime(struct tm *);
int nanosleep(const struct timespec *rqtp, struct timespec *rmtp);
size_t strftime(char *str, size_t maxsize, const char *fmt, const struct tm *ts);
//size_t strftime_l(char *, size_t, const char *, const struct tm *, locale_t);
char *strptime(const char *, const char *, struct tm *);
time_t time(time_t *tloc);
int timer_create(clockid_t clock_id, struct sigevent *evp, timer_t *timerid);
int timer_delete(timer_t timerid);
int timer_getoverrun(timer_t timerid);
int timer_gettime(timer_t timerid, struct itimerspec *value);
int timer_settime(timer_t timerid, int flags, const struct itimerspec *value, struct itimerspec *ovalue);
void tzset(void);
//non posix
int clock_init(clockid_t clockid, const struct timespec *res);
void timer_tick(clockid_t clockid);
time_t uptime(time_t *tloc);


/* for timer_settime flags */
#define TIMER_ABSTIME       1

#define NANOSECOND          1000000000L

/* Some handy conversions to nanoseconds. It is so easy to get all those
   zeros wrong. */
#define SECOND2NANO(n)      ((n) * 1000000000L)
#define MILLISEC2NANO(n)    ((n) * 1000000L)
#define MICROSEC2NANO(n)    ((n) * 1000L)

#ifdef __cplusplus
} //extern "C" {
#endif

#endif /* _POSIX_TIMERS */
#endif /* _time_h_ */
