/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _unistd_h
#define _unistd_h

#ifdef __cplusplus
extern "C" {
#endif

/* Unistd.h */

/* kfatal() is a user-defined routine that does something useful with the
   error number. The default routine writes the error number to a global
   variable, disables interrupts, and spins. */
/* The error numbers passable to kfatal are listed in errno.h, and all start
   with FAT_... */
/* Finally, the error codes are 32 bits long. Hence the ulong, as Nano is
   targeted at smaller-than-32-bit machines. */
void kfatal (unsigned long error);

/* Posix test macros and Nano build options */

/* There are four Nano build options. These options remove some code from
   general areas of the kernel, allowing for a smaller kernel for
   applications that don't use these features. */
/* These options do not cover all the feature sets, or all the Posix feature
   test macros. This is simply because Posix messages and semaphors, and
   Unison messages and rendezvous features carry no overhead within the
   kernel. They are completely self contained, and if you don't reference
   them in your code, the linker brings none of it in. */
/* The build options, however, cover areas that affect the context switch and
   the handling of the ready queue and waiting queues. They remove fields
   from the task descriptor and code that handles the capabilities the
   options cover. */

/* NANO_OPTION_NO_TIMERS (Implies NANO_OPTION_NO_TIMEOUTS) Removes all the
   machinery that handles timers, and removes the timer_tick() function and
   the various sleep functions. Removes round-robin stuff from the task
   descriptor. */

/* NANO_OPTION_NO_TIMEOUTS Removes all the machinery that handles timeouts,
   including the dedicated timer built into the task descriptor. Removes all
   timeout functons, like mq_timedreceive. Unison rendezvous functions will
   wiat forever if their timeout parameters indicate a wait (and not a poll) */

/* NANO_OPTION_NO_PRIORITY_SCHEDULING: Implies
   NANO_OPTION_NO_PRIORITY_INHERIT. All threads run at the same priority,
   code that moves task descriptors around is simplified. Fifo and
   Round-Robin scheduling (if timers are included) still apply at the one
   priority level. */

/* NANO_OPTION_NO_PRIORITY_INHERIT: Disable priority inheritance on thread
   mutexes. With this feature disabled, threads only have an assigned
   priority, and thread mutex grabbing code is simplified. With inheritance
   enabled, threads have their assigned priority, but will run at their
   effective priority (which could be higher) if they hold a mutex. */
#define NANO_OPTION_NO_PRIORITY_INHERIT
#ifdef NANO_OPTION_NO_PRIORITY_SCHEDULING
  #error Disabling priority scheduling not implemented yet!
#endif


#define _POSIX_VERSION  200112L
#undef _XOPEN_VERSION

/* Set up POSIX test macros for the selected Nano build options */

#if defined(NANO_OPTION_NO_TIMERS)
  #define _POSIX_TIMERS -1
  #define _POSIX_TIMEOUTS -1
#else /* no timers */
  #define _POSIX_TIMERS 200112L
  #if defined(NANO_OPTION_NO_TIMEOUTS)
    #define _POSIX_TIMEOUTS -1
  #else /* no timeouts */
    #define _POSIX_TIMEOUTS 200112L
  #endif /* no timeouts */
#endif /* no timers */

#if defined(NANO_OPTION_NO_PRIORITY_SCHED)
  #define _POSIX_PRIORITY_SCHEDULING -1
  #define _POSIX_THREAD_PRIORITY_SCHEDULING -1
  #define _POSIX_THRED_PRIO_INHERIT -1
#else /* no priority scheduling */
  #define _POSIX_PRIORITY_SCHEDULING 200112L
  #define _POSIX_THREAD_PRIORITY_SCHEDULING 200112L
  #if defined(NANO_OPTION_NO_PRIORITY_INHERIT)
    #define _POSIX_THREAD_PRIO_INHERIT -1
  #else /* no priority inheritance */
    #define _POSIX_THREAD_PRIO_INHERIT 200112L
  #endif /* no priority inheritance */
#endif /* no priority scheduling */

/* These features are always enabled. */
#define _POSIX_MESSAGE_PASSING          200112L
#define _POSIX_SEMAPHORES               200112L
#define _POSIX_THREAD_ATTR_STACKADDR    200112L
#define _POSIX_THREAD_ATTR_STACKSIZE    200112L
#define _POSIX_THREADS                  200112L


#ifndef NANO_OPTION_NO_PRIORITY_INHERIT
  #error Nano Priority Inheritance NOT implemented yet!
#endif


#include <sys/types.h>

/* access function */
#define F_OK        0    /* test for existence of file */
#define X_OK        0x01    /* test for execute or search permission */
#define W_OK        0x02    /* test for write permission */
#define R_OK        0x04    /* test for read permission */

ssize_t write(int fildes, const void *buf, size_t nbyte);
ssize_t read(int fildes, void *buf, size_t nbyte);
int unlink(const char *path);
int link(const char *src, const char *dst);
void sync(const char *server);
int fsync(int fildes);
int close(int fildes);
off_t lseek(int fildes, off_t offset, int relative);

int rmdir(const char *);

unsigned int sleep(unsigned int seconds);
int usleep(useconds_t useconds);

char *ctermid(char *s);
int fork(void);
int isatty(int file);
void _exit(int);


int access(const char *path, int amode);
int chdir(const char *path);
int ftruncate(int fildes, off_t length);
int truncate(const char *path, off_t length);

#ifdef __cplusplus
} //extern "C" {
#endif

#endif /* _unistd_h */
