/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef __time_h_
#define __time_h_

/* The timer control block structure. The first 24 bytes overlap the Thread
   descriptor. */
typedef struct
{
    struct Gqueue queue;
    timer_t timerid;
    unsigned int state;
    struct timespec timeout;
    /* end of common */
    struct timespec period;
    struct Thread *td;
    struct sigevent event;
} TMCB;

// Timer internal states
#define TIMER_ARMED 1U
#define TIMER_ABS   2U

void insertTimerQueue(TMCB * tmcb);
void __timer_gettime(TMCB *tmcb, struct itimerspec *value);
void __timer_settime(TMCB *tmcb, int flags,
               const struct itimerspec *value, struct itimerspec *ovalue);

/* return 1 if (t1 <= t2) and 0 otherwise. t1 and t2 are struct timeval's */
#define timer_le(t1, t2) \
    (((t1).tv_sec < (t2).tv_sec) || \
    (((t1).tv_sec == (t2).tv_sec) && ((t1).tv_nsec <= (t2).tv_nsec)))

/* return 1 if (t1 < t2) and 0 otherwise. t1 and t2 are struct timeval's */
#define timer_lt(t1, t2) \
    (((t1).tv_sec < (t2).tv_sec) || \
    (((t1).tv_sec == (t2).tv_sec) && ((t1).tv_nsec < (t2).tv_nsec)))

/* Note that only the creating thread can access the timer */
#define VALID_TIMERID(timerid)    \
    ((((TMCB*)(timerid))->timerid == (timerid)) && \
    (_Active == ((TMCB*)(timerid))->td))

#define ZeroTime(t)    (((t)->tv_sec == 0) && ((t)->tv_nsec == 0))

extern struct timespec CurrentTime;
extern struct timespec UpTime;

extern long _Timer_period;
extern struct Gqueue TimerQ;


#endif /* __time_h_ */
