/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _dlog_kernel_ev_h_
#define _dlog_kernel_ev_h_


/*
 * Data logger is supported in commercial version
 */



/*
 * Malloc functions
 */
#define DLOG_MALLOC_INSERT
#define DLOG_FREE_INSERT

/*
 * Pool functions
 */
#define DLOG_POOL_CREATE_INSERT
#define DLOG_POOL_DESTROY_INSERT
#define DLOG_POOL_ALLOC_INSERT
#define DLOG_POOL_FREE_INSERT

/*
 * pt_xxx functions
 */
#define DLOG_PT_CREATE_INSERT
#define DLOG_PT_DESTROY_INSERT
#define DLOG_PT_GETBLOCK_INSERT
#define DLOG_PT_FREEBLOCK_INSERT

/*
 * Message queue functions
 */
#define DLOG_MQ_OPEN_INSERT
#define DLOG_MQ_CLOSE_INSERT
#define DLOG_MQ_UNLINK_INSERT
#define DLOG_MQ_RECEIVE_INSERT
#define DLOG_MQ_SEND_INSERT

/*
 * Message rendezvous functions
 */
#define DLOG_MR_INIT_INSERT
#define DLOG_MR_RECEIVE_INSERT
#define DLOG_MR_REPLY_INSERT
#define DLOG_MR_SEND_INSERT
#define DLOG_MR_SIGPOST_INSERT
#define DLOG_MR_SIGRECV_INSERT

/*
 * Barrier functions
 */
#define DLOG_PTHREAD_BARRIER_INIT_INSERT
#define DLOG_PTHREAD_BARRIER_DESTROY_INSERT
#define DLOG_PTHREAD_BARRIER_WAIT_INSERT

/*
 * Cancel functions
 */
#define DLOG_PTHREAD_CANCEL_INSERT
#define DLOG_PTHREAD_TESTCANCEL_INSERT
#define DLOG_PTHREAD_CLEANUP_PUSH_INSERT
#define DLOG_PTHREAD_CLEANUP_POP_INSERT
#define DLOG_PTHREAD_SETCANCELSTATE_INSERT
#define DLOG_PTHREAD_SETCANCELTYPE_INSERT

/*
 * Condition variable functions
 */
#define DLOG_PTHREAD_COND_INIT_INSERT
#define DLOG_PTHREAD_COND_DESTROY_INSERT
#define DLOG_PTHREAD_COND_BROADCAST_INSERT
#define DLOG_PTHREAD_COND_SIGNAL_INSERT
#define DLOG_PTHREAD_COND_WAIT_INSERT

/*
 * Pthread state functions
 */
#define DLOG_PTHREAD_CREATE_INSERT
#define DLOG_PTHREAD_EXIT_INSERT
#define DLOG_PTHREAD_JOIN_INSERT
#define DLOG_SCHED_YIELD_INSERT
// Non maskable event
#define DLOG_PTHREAD_CHANGE_STATE_INSERT
// Non maskable event
#define DLOG_PTHREAD_RUN_INSERT

/*
 * Pthread mutex functions
 */
#define DLOG_PTHREAD_MUTEX_INIT_INSERT
#define DLOG_PTHREAD_MUTEX_DESTROY_INSERT
#define DLOG_PTHREAD_MUTEX_LOCK_INSERT
#define DLOG_PTHREAD_MUTEX_TRYLOCK_INSERT
#define DLOG_PTHREAD_MUTEX_UNLOCK_INSERT
#define DLOG_PTHREAD_MUTEX_TIMEDLOCK_INSERT

/*
 * Semaphore functions
 */
#define DLOG_SEM_OPEN_INSERT
#define DLOG_SEM_INIT_INSERT
#define DLOG_SEM_CLOSE_INSERT
#define DLOG_SEM_DESTROY_INSERT
#define DLOG_SEM_UNLINK_INSERT
#define DLOG_SEM_POST_INSERT
#define DLOG_SEM_WAIT_INSERT
#define DLOG_SEM_TIMEDWAIT_INSERT
#define DLOG_SEM_TRYWAIT_INSERT

/*
 * Timer functions
 */
#define DLOG_NANOSLEEP_INSERT
#define DLOG_TIMER_CREATE_INSERT
#define DLOG_TIMER_DELETE_INSERT
#define DLOG_TIMER_GETTIME_INSERT
#define DLOG_TIMER_SETTIME_INSERT

/*
 * Clock functions
 */
#define DLOG_CLOCK_INIT_INSERT
#define DLOG_CLOCK_SETTIME_INSERT
#define DLOG_CLOCK_GETRES_INSERT
#define DLOG_CLOCK_GETTIME_INSERT



/*
 * Interrupt functions
 */
#define DLOG_INTERRUPT_BEGIN_INSERT
#define DLOG_INTERRUPT_END_INSERT


#endif /* _dlog_kernel_ev_h_ */
