/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#include <sys.h>
#include <pthread.h>
#include "dlog_kernel_ev.h"
#include "kernel.h"


/**
 * @addtogroup Internal_pthread_group pthread
 * @{
 */


/**
 *  @brief      Internal function for using pthread_cleanup_push
 *
 *  @param [in] routine: pointer on pushes cleanup handler
 *  @param [in] arg: cleanup handler argument
 *  @param [in] handler: internal structure for saving data
 *
 *  @return no return value.
*/
void __pthread_cleanup_push(void (*routine)(void *arg), void *arg,
    struct _pthread_cleanup_handler *handler)
{
    // Log this kernel function
    DLOG_PTHREAD_CLEANUP_PUSH_INSERT;

    handler->routine = routine;
    handler->arg = arg;
    handler->prev = (struct _pthread_cleanup_handler *)_Active->cleanup_stack;
    _Active->cleanup_stack = (void*)handler;
}


/**
 *  @brief      Internal function for using pthread_cleanup_pop
 *
 *  @param [in] execute: if (1) is called before deletion or if (0) is not called
 *  @param [in] handler: internal structure for saving data
 *
 *  @return no return value.
 */
void __pthread_cleanup_pop(int execute,    struct _pthread_cleanup_handler *handler)
{
    // Log this kernel function
    DLOG_PTHREAD_CLEANUP_POP_INSERT;

    _Active->cleanup_stack = (void*)handler->prev;
    if (execute != 0)
        handler->routine(handler->arg);
}


/**
 * @} end Internal pthread group
 */
