/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#include <sys.h>
#include "kernel.h"
#include "_pthread.h"


/**
 * @addtogroup pthread_group pthread
 * @{
 */


 /**
 *  @brief Thread get attributes.
 *
 *  @param [in]  thread_id: thread identificator.
 *  @param [out] attr: pointer for get attributes
 *
 *  @return     0: success.
 *  @return     ENOMEM: error. not enough memory.
 *  @return     ESRCH: error. thread can not be found.
 *
 *
 *  Initialize thread attribute *ATTR with attributes corresponding to the
 *  already running thread TH.  It shall be called on unitialized ATTR
 *  and destroyed with pthread_attr_destroy when no longer needed. (NON POSIX)
 */
int pthread_getattr_np(pthread_t thread_id, pthread_attr_t *attr)
{
    Thread *td;
    uint tmp;

    td = ConvertToTD(thread_id);
    if (td == NULL)
        return ESRCH;

    attr->attrp = kalloc(KA_PTHRATTR, sizeof(_pthread_attr_t));
    if (attr->attrp == NULL)
        return ENOMEM;
    (void)memset(attr->attrp, 0, sizeof(_pthread_attr_t));

    tmp = (uint)td->td_myqueue - (uint)_Ready_q;         // get distance between current queue address and top of queues address
    tmp = tmp / (uint)sizeof(struct Gqueue);             // get priority (each queue is struct Gqueue)

    PTHREAD_ATTR(attr)->priority = (int)tmp;
    PTHREAD_ATTR(attr)->stackbase = td->td_stackbase;
    PTHREAD_ATTR(attr)->stacksize = td->td_stacksize;
    PTHREAD_ATTR(attr)->detachstate = td->detachstate;

    return 0;
}


/**
 * @} end pthread group
 */
