;/*
;*********************************************************************************************************
;*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
;*                                            for STM32Cube
;*
;*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
;*                                           www.rowebots.com
;*********************************************************************************************************
;* Licensing:
;*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
;* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
;*    not download or use this software for any reason.
;* 2. Information about RoweBots licensing regarding this software available at
;*    www.rowebots.com/products/licensing/st-v1.
;* 3. It is your obligation to select an appropriate license based on your intended use of the
;*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
;* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
;*    offering is limited to evaluation, educational or personal non-commercial uses.
;* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
;*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
;*    with the caveat that fees for commercial use are waived for those components.
;* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
;*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
;*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
;*********************************************************************************************************
;* Documentation and Working Examples:
;*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
;*    examples are in ready to run state.
;*********************************************************************************************************
;* Technical Support:
;*    Support is available for all users of RoweBots software. For additional information on support, see
;*    www.rowebots.com/support or you can contact support@rowebots.com.
;*********************************************************************************************************
;*/

#include "port.h"


  EXPORT StartFirstTask_Handler
  EXPORT TaskSwitch_Handler
  EXPORT StartFirstTask

  IMPORT _Active
  IMPORT errno
  IMPORT ContextSwitch


  AREA    |.text|, CODE, READONLY


;16-bits commands
  THUMB

; Interrupt handler for first task starting.
; Called from StartFirstTask().
StartFirstTask_Handler
#if defined(__ARMCORTEXM0__)
    ldr         r0, =_Active
    ldr         r2, [r0]
    ldr         r0, [r2, #8]            ;Stack offset in structure

    adds        r0, r0, #16
    ldmia       r0!, {r4-r7}            ;Load the high registers
    mov         r8, r4                  ;Store the high registers
    mov         r9, r5
    mov         r10, r6
    mov         r11, r7
    ldmia       r0!, {r4-r5}            ;Load R14 and Int status
    mov         r14, r4
    msr         primask, r5             ;Set int status

    msr         psp, r0                 ;Write R0 to Process Stack Pointer

    subs        r0, r0, #40             ;Go back for the low registers that are not automatically restored.
    ldmia       r0!, {r4-r7}            ;Load the low registers

    ldr         r1, [r2, #24]           ;errno offset in structure
    ldr         r0, =errno
    str         r1, [r0]

    ;Return to Thread mode, uses PSP
    mov         r1, r14                 ;OR R14 with 0x0d
    movs        r0, #0x0d
    orrs        r1, r0
    bx          r1

#elif defined(__ARMCORTEXM3__) || defined(__ARMCORTEXM4__) || defined(__ARMCORTEXM4F__) || defined(__ARMCORTEXM7__)
    ldr         r0, =_Active
    ldr         r2, [r0]
    ldr         r0, [r2, #8]            ;Stack offset in structure

    ldmia       r0!, {r4-r11, r14}      ;Load registers

#if defined(__ARMCORTEXM4F__) || defined(__ARMCORTEXM7__)
    ;If the FPU context using, load high vfp registers
    tst         r14, #0x10
    it          EQ
    vldmiaeq    r0!, {s16-s31}
#endif

    ldmia       r0!, {r1}               ;Int status
    msr         primask, r1             ;Int enable

    msr         psp, r0                 ;Write R0 to Process Stack Pointer

    ldr         r1, [r2, #24]           ;errno offset in structure
    ldr         r0, =errno
    str         r1, [r0]

    ;Return to Thread mode, uses PSP
    ;0xfffffffd - non-floating-point state
    ;0xffffffed - floating-point state
    orr         r14, r14, #0xd
    bx          r14
#endif /* (__ARMCORTEXM3__ || __ARMCORTEXM4__ || __ARMCORTEXM4F__ || __ARMCORTEXM7__) */



;This interrupt is called after all interrupts.
;This function make context store/restore and tasks switch.
TaskSwitch_Handler
    cpsid       i                       ;Disable interrupt

#if defined(__ARMCORTEXM0__)
    ; Store task context
    mrs         r1, psp                 ;Get task stack

    ldr         r2, =_Active
    ldr         r2, [r2]

    ldr         r0, =errno
    ldr         r0, [r0]
    str         r0, [r2, #24]           ;errno offset in structure

    subs        r1, r1, #40             ;Adjust stack pointer to where memory needs to be stored
                                        ;40 bytes = r4-r11 + r14 + 4 bytes Int status, default increments SP after each storing
    stm         r1!, {r4-r7}            ;Save rest registers
    mov         r4, r8                  ;Store the high registers
    mov         r5, r9
    mov         r6, r10
    mov         r7, r11
    stm         r1!, {r4-r7}            ;Save rest registers

    mov         r4, r14
    movs        r5, #0                  ;Int status =1, if we in _Relinquish
    stm         r1!, {r4-r5}            ;Save R14 and Int status
    subs        r1, r1, #40             ;CM0+ does not automatically call back the SP to initial location so we must do this manually

    str         r1, [r2, #8]            ;Save new stack


    ;Change task
    BL ContextSwitch


    ; Load new task context
    ldr         r0, =_Active
    ldr         r2, [r0]
    ldr         r0, [r2, #8]            ;Stack offset in structure

    adds        r0, r0, #16
    ldmia       r0!, {r4-r7}            ;Load the high registers
    mov         r8, r4                  ;Store the high registers
    mov         r9, r5
    mov         r10, r6
    mov         r11, r7
    ldmia       r0!, {r4-r5}            ;Load R14 and Int status
    mov         r14, r4
    msr         primask, r5             ;Set int status

    msr         psp, r0                 ;Write R0 to Process Stack Pointer

    subs        r0, r0, #40             ;Go back for the low registers that are not automatically restored.
    ldmia       r0!, {r4-r7}            ;Load the low registers

    ldr         r1, [r2, #24]           ;errno offset in structure
    ldr         r0, =errno
    str         r1, [r0]

    ;Return to Thread mode, uses PSP
    mov         r1, r14                 ;OR R14 with 0x0d
    movs        r0, #0x0d
    orrs        r1, r0
    bx          r1

#elif defined(__ARMCORTEXM3__) || defined(__ARMCORTEXM4__) || defined(__ARMCORTEXM4F__) || defined(__ARMCORTEXM7__)
    ;Store task context
    mrs         r1, psp                 ;Get task stack

    ldr         r2, =_Active
    ldr         r2, [r2]

    ldr         r0, =errno
    ldr         r0, [r0]
    str         r0, [r2, #24]           ;errno offset in structure

    mov         r0, #0                  ;Int status =1, if we in _Relinquish
    //stmdb       r1!, {r0}               ;Save int status
    str.w       r0,[r1,#-4]!            ;Save int status

#if defined(__ARMCORTEXM4F__) || defined(__ARMCORTEXM7__)
    ;If the FPU context using, save high vfp registers
    tst         r14, #0x10
    it          EQ
    vstmdbeq    r1!, {s16-s31}
#endif

    stmdb       r1!, {r4-r11, r14}      ;Save rest registers
    str         r1, [r2, #8]            ;Save new stack


    ;Change task
    BL ContextSwitch


    ;Load new task context
    ldr         r0, =_Active
    ldr         r2, [r0]
    ldr         r0, [r2, #8]            ;Stack offset in structure

    ldmia       r0!, {r4-r11, r14}      ;Load registers

#if defined(__ARMCORTEXM4F__) || defined(__ARMCORTEXM7__)
    ;If the FPU context using, load high vfp registers
    tst         r14, #0x10
    it          EQ
    vldmiaeq    r0!, {s16-s31}
#endif

    ldmia       r0!, {r1}               ;Load int status
    msr         primask, r1             ;Set int status

    msr         psp, r0                 ;Write R0 to Process Stack Pointer

    ldr         r1, [r2, #24]           ;errno offset in structure
    ldr         r0, =errno
    str         r1, [r0]

    ;Return to Thread mode, uses PSP
    ;0xfffffffd - non-floating-point state
    ;0xffffffed - floating-point state
    orr         r14, r14, #0xd
    bx          r14
#endif /* (__ARMCORTEXM3__ || __ARMCORTEXM4__ || __ARMCORTEXM4F__ || __ARMCORTEXM7__) */



;Start first RTOS thread
StartFirstTask
    ldr         r0, =0xE000ED08         ;Vector Table Offset Register
    ldr         r0, [r0]                ;Pointer to stack
    ldr         r0, [r0]                ;Stack
    msr         msp, r0                 ;Write R0 to Main Stack Pointer
    cpsie       i                       ;Enable interrupts
    svc         0                       ;Interrupt for start first task
    bx          LR


    END
