/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _signal_h_
#define _signal_h_

#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

union sigval
{
    int sival_int;
    void *sival_ptr;
};


struct sigevent
{
    int sigev_notify;            //Notification type.
    int sigev_signo;             //Signal number.
    union sigval sigev_value;    //Signal value.
//  void (*sigev_notify_function)(union sigval)     //Notification function.
//  pthread_attr_t *sigev_notify_attributes         //Notification attributes.
};


#define SIG_DFL        (void (*)(int))0
#define SIG_IGN        (void (*)(int))1
#define SIG_ERR        (void (*)(int))-1


typedef unsigned long sigset_t;        /* at least 32 bits */
typedef unsigned int sig_atomic_t;


/* sigev_notify types */
#define SIGEV_NONE      0
#define SIGEV_SIGPOST   1
//#define SIGEV_SIGNAL    2
#define SIGEV_SIGNAL    SIGEV_SIGPOST

/* argument to sigprocmask */
#define SIG_BLOCK       1
#define SIG_UNBLOCK     2
#define SIG_SETMASK     3


#define SIGHUP          1    /* hangup */
#define SIGINT          2    /* interrupt */
#define SIGQUIT         3    /* quit */
#define SIGILL          4    /* illegal instruction */
#ifndef _POSIX_SOURCE
  #define SIGTRAP       5    /* break point trap */
#endif
#define SIGABRT         6    /* abort */
#ifndef _POSIX_SOURCE
  #define SIGIOT        SIGABRT
  #define SIGEMT        7    /* emulator trap */
#endif
#define SIGFPE          8    /* floating point exception */
#define SIGKILL         9    /* kill */
#ifndef _POSIX_SOURCE
  #define SIGBUS        10    /* bus error */
#endif
#define SIGSEGV         11    /* segmentation violation */
#ifndef _POSIX_SOURCE
  #define SIGSYS        12    /* bad argument to system call */
#endif
#define SIGPIPE         13    /* write on a pipe with no one to read it */
#define SIGALRM         14    /* alarm clock */
#define SIGTERM         15    /* software termination signal */
#ifndef _POSIX_SOURCE
  #define SIGURG        16    /* urgent condition (on socket) */
#endif
#define SIGSTOP         17    /* stop (cannot be caught or ignored) */
#define SIGTSTP         18    /* interactive stop signal */
#define SIGCONT         19    /* continue if stopped */
#define SIGCHLD         20    /* child process terminated or stopped */
#define SIGTTIN         21    /* to reader's process group on bg read */
#define SIGTTOU         22    /* to writer's process group on bg write */
#ifndef _POSIX_SOURCE
  #define SIGIO         23    /* input/output possible signal */
  #define SIGPOLL       23    /* System V i/o possible */
  #define SIGXCPU       24    /* exceeded CPU time limit */
  #define SIGXFSZ       25    /* exceeded file size limit */
  #define SIGVTALRM     26    /* virtual time alarm */
  #define SIGPROF       27    /* profiling time alarm */
  #define SIGWINCH      28    /* window size changes */
  #define SIGINFO       29    /* information request */
#endif
#define SIGUSR1         30    /* user defined signal 1 */
#define SIGUSR2         31    /* user defined signal 2 */


typedef struct
{
    int si_signo;           //Signal number.
    int si_code;            //Signal code.
    int si_errno;           //If non-zero, an errno value associated with  this signal, as defined in <errno.h>.
    pid_t si_pid;           //Sending process ID.
    uid_t si_uid;           //Real user ID of sending process.
    void *si_addr;          //Address of faulting instruction.
    int si_status;          //Exit value or signal.
    long si_band;           //Band event for SIGPOLL.
    union sigval si_value;  //Signal value.
}siginfo_t;


struct sigaction
{
    void (*sa_handler)(int);    //Pointer to a signal-catching function or one of the macros SIG_IGN or SIG_DFL.
    sigset_t sa_mask;           //Set of signals to be blocked during execution of the signal handling function.
    int sa_flags;               //Special flags.
    void (*sa_sigaction)(int, siginfo_t *, void *); //Pointer to a signal-catching function.
};

//--------------------------------------------------------------------//

#ifdef __cplusplus
} //extern "C" {
#endif

#endif /* _signal_h_ */
