/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef __STDINT_H__
#define __STDINT_H__

#include <bits/local_lim.h>
#include <nano_limits.h>
#include <sys/types.h>


#ifdef __int64_t_defined
#define __u_int64_defined__
#endif

/****************** Pre-processor Definitions ******************/
#define INT8_MIN            (-0x7f-1)
#define INT8_MAX            0x7f
#define UINT8_MAX           0xffU

#define INT16_MIN           (-0x7fff-1)
#define INT16_MAX           0x7fff
#define UINT16_MAX          0xffffU

#ifdef __u_int24_defined__
  #define INT24_MIN         (-0x7fffff-1)
  #define INT24_MAX         0x7fffff
  #define UINT24_MAX        0xffffffU
#endif

#define INT32_MIN           (-0x7fffffff-1)
#define INT32_MAX           0x7fffffff
#define UINT32_MAX          0xffffffffU

#ifdef __u_int64_defined__
  #define INT64_MIN         (-0x7fffffffffffffffL-1)
  #define INT64_MAX         0x7fffffffffffffffL
  #define UINT64_MAX        0xffffffffffffffffUL
#endif

// Limits of minimum-width integer types

#define INT_LEAST8_MIN     (-0x7f-1)
#define INT_LEAST8_MAX     0x7f
#define UINT_LEAST8_MAX    0xffU

#define INT_LEAST16_MIN    (-0x7fff-1)
#define INT_LEAST16_MAX    0x7fff
#define UINT_LEAST16_MAX   0xffffU

#ifdef __u_int24_defined__
  #define INT_LEAST24_MIN  (-0x7fffffff-1)
  #define INT_LEAST24_MAX  0x7fffff
  #define UINT_LEAST24_MAX 0xffffffU
#endif

#define INT_LEAST32_MIN    (-0x7fffff-1)
#define INT_LEAST32_MAX    0x7fffffff
#define UINT_LEAST32_MAX   0xffffffffU

#ifdef __u_int64_defined__
  #define INT_LEAST64_MIN  (-0x7fffffffffffffffL-1)
  #define INT_LEAST64_MAX  0x7fffffffffffffff
  #define UINT_LEAST64_MAX 0xffffffffffffffffUL
#endif

//Limits of fastest minimum-width integer types

#define INT_FAST8_MIN      (-0x7f-1)
#define INT_FAST8_MAX      0x7f
#define UINT_FAST8_MAX     0xffU

#define INT_FAST16_MIN     (-0x7fff-1)
#define INT_FAST16_MAX     0x7fff
#define UINT_FAST16_MAX    0xffffU

#ifdef __u_int24_defined__
  #define INT_FAST24_MIN   (-0x7fffffff-1)
  #define INT_FASTN24_MAX  0x7fffff
  #define UINT_FAST24_MAX  0xffffffU
#endif

#define INT_FAST32_MIN     (-0x7fffff-1)
#define INT_FAST32_MAX     0x7fffffff
#define UINT_FAST32_MAX    0xffffffffU

#ifdef __u_int64_defined__
  #define INT_FAST64_MIN   (-0x7fffffffffffffffL-1)
  #define INT_FAST64_MAX   0x7fffffffffffffff
  #define UINT_FAST64_MAX  0xffffffffffffffffUL
#endif

//Limits of integer types capable of holding object pointers
#if __WORDSIZE == 16
  #define INTPTR_MIN        INT16_MIN
  #define INTPTR_MAX        INT16_MAX
  #define UINTPTR_MAX       UINT16_MAX
#elif __WORDSIZE == 32
  #define INTPTR_MIN        INT32_MIN
  #define INTPTR_MAX        INT32_MAX
  #define UINTPTR_MAX       UINT32_MAX
#endif

//Limits of greatest-width integer types
#ifdef __u_int64_defined__
  #define INTMAX_MIN        INT64_MIN
  #define INTMAX_MAX        INT64_MAX

  #define UINTMAX_MIN       UINT64_MIN
  #define UINTMAX_MAX       UINT64_MAX
#else
  #define INTMAX_MIN        INT32_MIN
  #define INTMAX_MAX        INT32_MAX

  #define UINTMAX_MIN       UINT32_MIN
  #define UINTMAX_MAX       UINT32_MAX
#endif

//Macros for minimum-width integer constant expressions
#define INT8_C(x) x
#define INT16_C(x) x
#define INT32_C(x) x ## L
#define INT64_C(x) x ## LL

#define UINT8_C(x) x
#define UINT16_C(x) x
#define UINT32_C(x) x ## UL
#define UINT64_C(x) x ## ULL


//Macros for greatest-width integer constant expressions
#if __have_long64
  #define INTMAX_C(x) x ## L
  #define UINTMAX_C(x) x ## UL
#else
  #define INTMAX_C(x) x ## LL
  #define UINTMAX_C(x) x ## ULL
#endif

//Limits of Other Integer Types
#define PTRDIFF_MIN             (-0xffff)
#define PTRDIFF_MAX             0xffff

#if __WORDSIZE == 16
  #define SSIZE_MAX             0x7fff
  #define SIZE_MAX              0xffff
#elif __WORDSIZE == 32
  #define SSIZE_MAX             0x7fffffff
  #define SIZE_MAX              0xffffffff
#else
  #error You must define the platform bits for this port!
#endif

#define SIG_ATOMIC_MIN          0
#define SIG_ATOMIC_MAX          0x7f

#define WCHAR_MIN               0U
#define WCHAR_MAX               0x7fffU

#if __WORDSIZE == 16
  #define WINT_MIN          INT16_MIN
  #define WINT_MAX          INT16_MAX
#elif __WORDSIZE == 32
  #define WINT_MIN          INT32_MIN
  #define WINT_MAX          INT32_MAX
#endif

/******************  Public Types ******************/

typedef int_8       int8_t;
typedef uint_8      uint8_t;

typedef int_16      int16_t;
typedef uint_16     uint16_t;

#ifdef __u_int24_defined__
  typedef int_24    int24_t;
  typedef uint_24   uint24_t;
#endif

typedef int_32      int32_t;
typedef uint_32     uint32_t;

#ifdef __u_int64_defined__
  typedef int_64    int64_t;
  typedef uint_64   uint64_t;
#endif

//Minimum-width integer types

typedef int_8       int_least8_t;
typedef uint_8      uint_least8_t;

typedef int_16      int_least16_t;
typedef uint_16     uint_least16_t;

#ifdef __u_int24_defined__
  typedef int_24    int_least24_t;
  typedef uint_24   uint_least24_t;
#else
  typedef int_32    int_least24_t;
  typedef uint_32   uint_least24_t;
#endif

typedef int_32      int_least32_t;
typedef uint_32     uint_least32_t;

#ifdef __u_int64_defined__
  typedef int_64    int_least64_t;
  typedef uint_64   uint_least64_t;
#endif

//Fastest minimum-width integer types

typedef int_8       int_fast8_t;
typedef uint_8      uint_fast8_t;

typedef int_16      int_fast16_t;
typedef uint_16     uint_fast16_t;

#ifdef __u_int24_defined__
  typedef int_24    int_fast24_t;
  typedef uint_24   uint_fast24_t;
#else
  typedef int_32    int_fast24_t;
  typedef uint_32   uint_fast24_t;
#endif

typedef int_32      int_fast32_t;
typedef uint_32     uint_fast32_t;

#ifdef __u_int64_defined__
  typedef int_64    int_fast64_t;
  typedef uint_64   uint_fast64_t;
#endif

// Integer types capable of holding object pointers

typedef _intptr_t   intptr_t;
typedef _uintptr_t  uintptr_t;

// Greatest-width integer types

#ifdef __u_int64_defined__
  typedef int_64    intmax_t;
  typedef uint_64   uintmax_t;
#else
  typedef int_32    intmax_t;
  typedef uint_32   uintmax_t;
#endif

#endif //__STDINT_H__
