/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#include <sys.h>
#include <mrendez.h>
#include "dlog_kernel_ev.h"
#include "kernel.h"


/**
 * @addtogroup rendezvous_group rendezvous
 * @{
 */


/**
 *  @brief     Receive signals from threads or ISRs
 *
 *  @param[in] portmask: 32 bit mask indicating which signals the thread is willing to accept.
 *
 *  @return    received signal.
 */
int mr_sigrecv(BitMask sigmask)
{
    Status ps;
    register BitMask mask;
    register int signo;
    register Thread *ap;

    // Log this kernel function
    DLOG_MR_SIGRECV_INSERT;

    ap = _Active;

    ap->td_sigmask = sigmask;

    ps = i_disable();
    while ((ap->td_sigpend & ap->td_sigmask) == 0U)
    {
        remqueue((struct Gqueue *)ap);
        ap->td_state = RCV_BLOCKED;
        _Relinquish(ps);
        ps = i_disable();
    }

    mask = ap->td_sigpend & ap->td_sigmask;
    signo = find_first_bit(mask);
    ap->td_sigpend &= ~((BitMask)1 << (BitMask)signo);
    i_restore(ps);

    return signo;
}

/**
 * @} end rendezvous group
 */
