/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef __mqueue_h_
#define __mqueue_h_

#include <mqueue.h>
#include "kernel.h"


/* Actual message on queue */
typedef struct
{
    struct Gqueue queue;
    int len;
    unsigned prio;
  /* message starts here */
} MsgQueue;

/* This structure is allocated on a per queue basis */
typedef struct QCB
{
    struct QCB *next;
    int ocount;                 /* open count */
    struct mq_attr attr;        /* posix requires this */
    char *msg;                  /* so we can free it */
    struct Gqueue fQueue;       /* free list queue */
    struct Gqueue mQueue;       /* message queue */
    struct Gqueue tQueue;       /* threads blocked on this queue */
    struct Gqueue rQueue;       /* resource wait queue */
    char name[1];               /* name - must be last */
} QCB;

/* This structure is allocated on a per mqd_t basis */
typedef struct
{
    long mq_flags;              /* O_NONBLOCK - we also store read/write flags */
    uint id;
    QCB *qcb;
} QD;

#define SENDOK(mq)  (((QD*)(mq))->mq_flags & O_WRONLY)
#define RECVOK(mq)  (((QD*)(mq))->mq_flags & O_RDONLY)

/* This is set by mq_unlink to mark that the queue should be unlinked after
   the last mq_close. This should never be set by the application. */
#define MQ_UNLINK    0x40000000L

#define VALID_MQUEUE(mq)	((unsigned int)(mq) == ((QD*)(mq))->id)

//QCB *qd2qcb (mqd_t qd);    // use macros
#define qd2qcb(qd)      (((QD*)(qd))->qcb)

QCB *name2qcb(const char *name, QCB **prevp);

extern QCB *qHead;

#endif /* __mqueue_h_ */
