/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _limits_h_
#define _limits_h_

#include <stdint.h>
#include <bits/local_lim.h>


//Number of bits in a type char.
#undef CHAR_BIT
#define CHAR_BIT 8

//Minimum and Maximum value for an object of type char.
#ifdef __CHAR_UNSIGNED__
  #undef CHAR_MIN
  #define CHAR_MIN 0
  #undef CHAR_MAX
  #define CHAR_MAX UINT8_MAX
#else
  #undef CHAR_MIN
  #define CHAR_MIN INT8_MIN
  #undef CHAR_MAX
  #define CHAR_MAX INT8_MAX
#endif

//Maximum value for an object of type int.
#undef INT_MAX
#define INT_MAX INT32_MAX

//Minimum value for an object of type int.
#undef INT_MIN
#define INT_MIN INT32_MIN

#ifdef __u_int64_defined__
  //Maximum value for an object of type long long.
  #undef LLONG_MAX
  #define LLONG_MAX INT64_MAX

  //Minimum value for an object of type long long.
  #undef LLONG_MIN
  #define LLONG_MIN INT64_MIN
#endif

//Number of bits in an object of type long.
#undef LONG_BIT
#define LONG_BIT 32

//Maximum value for an object of type long.
#undef LONG_MAX
#define LONG_MAX INT32_MAX

//Minimum value for an object of type long.
#undef LONG_MIN
#define LONG_MIN INT32_MIN

//Maximum number of bytes in a character, for any supported locale.
#ifndef MB_LEN_MAX
  #define MB_LEN_MAX 1
#endif

//Maximum value for an object of type signed char.
#undef SCHAR_MAX
#define SCHAR_MAX INT8_MAX

//Minimum value for an object of type signed char.
#undef SCHAR_MIN
#define SCHAR_MIN INT8_MIN

//Maximum value for an object of type short.
#undef SHRT_MAX
#define SHRT_MAX  INT16_MAX

//Minimum value for an object of type short.
#undef SHRT_MIN
#define SHRT_MIN INT16_MIN

//Maximum value for an object of type ssize_t.
#undef SSIZE_MAX
#if __WORDSIZE == 16
  #define SSIZE_MAX INT16_MAX
#else
  #define SSIZE_MAX INT32_MAX
#endif

//Maximum value for an object of type unsigned char.
#undef UCHAR_MAX
#define UCHAR_MAX UINT8_MAX

//Maximum value for an object of type unsigned.
//Minimum Acceptable Value: 4 294 967 295
#undef UINT_MAX
#define UINT_MAX UINT32_MAX

#ifdef __u_int64_defined__
  //Maximum value for an object of type unsigned long long.
  #undef ULLONG_MAX
  #define ULLONG_MAX UINT64_MAX
#endif

//Maximum value for an object of type unsigned long.
#undef ULONG_MAX
#define ULONG_MAX UINT32_MAX

//Maximum value for an object of type unsigned short.
#undef USHRT_MAX
#define USHRT_MAX UINT16_MAX

//Number of bits in an object of type int.
//Minimum Acceptable Value: 32
#undef WORD_BIT
#define WORD_BIT 32

#endif /* _limits_h_ */
