/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _nano_limits_h_
#define _nano_limits_h_

#include <bits/wordsize.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Minimum values */
#define _POSIX_AIO_LISTIO_MAX       2
#define _POSIX_AIO_MAX              1
#define _POSIX_ARG_MAX              4096
#define _POSIX_CHILD_MAX            6
#define _POSIX_DELAYTIMER_MAX       32
#define _POSIX_LINK_MAX             8
#define _POSIX_MAX_CANON            255
#define _POSIX_MAX_INPUT            255
#define _POSIX_MQ_OPEN_MAX          8
#define _POSIX_MQ_PRIO_MAX          32
#define _POSIX_NAME_MAX             14
#define _POSIX_NGROUPS_MAX          0
#define _POSIX_OPEN_MAX             16
#define _POSIX_PATH_MAX             255
#define _POSIX_PIPE_BUF             512
#define _POSIX_RTSIG_MAX            8
#define _POSIX_SEM_NSEMS_MAX        256
#define _POSIX_SEM_VALUE_MAX        32767
#define _POSIX_SIGQUEUE_MAX         32
#define _POSIX_SSIZE_MAX            32767
#define _POSIX_STREAM_MAX           8
#define _POSIX_TIMER_MAX            32
#define _POSIX_TZNAME_MAX           3
#define _POSIX_CLOCKRES_MIN         20000        /* nanoseconds */

/*
 * These defines should be modified, together with:
 * fsys\limits.h or fsys-fatfs\limits.h,
 * depending of file system used in your application
 */
#define PATH_MAX                    128
#define NAME_MAX                    50

/* Actual values */
#define MQ_PRIO_MAX                 _POSIX_MQ_PRIO_MAX
#define TIMER_MAX                   _POSIX_TIMER_MAX

#define SEM_VALUE_MAX               0x3fff

#define PTHREAD_PRIO_MAX            16
#define MR_SIG_MAX                  32


#ifdef __cplusplus
} //extern "C" {
#endif

#endif /* _nano_limits_h_ */
