/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#include <sys.h>
#include "dlog_kernel_ev.h"
#include "kernel.h"


/**
 * @addtogroup pthread_group pthread
 * @{
 */

/**
 *  @brief     Forces the running process to relinquish the processor until the thread again becomes the head of its priority list.
 *
 *  @retval    0: success.
 *  @retval   -1: error. Variable errno is set appropriately. (See errno.h)
 */
int sched_yield(void)
{
#if _POSIX_THREAD_PRIORITY_SCHEDULING > 0
    Status ps;

    // Log this kernel function
    DLOG_SCHED_YIELD_INSERT;

    ps = i_disable();

    /*
     * Here, some of compilers can generate a warning like "the order of volatile accesses
     * is undefined in this statement".
     *
     * "_Active" is a volatile variable and can be changed at any time in interrupts or other tasks.
     * The code below makes an operation under two variables pointed by "_Active".
     * So is it possible a situation when they will be changed during this operation.
     * To avoid it the code is executed inside a critical section i_disable()/i_restore().
     */
    movequeue((struct Gqueue *)_Active, (struct Gqueue *)_Active->td_myqueue);

    _Relinquish(ps);
    return 0;
#else
    errno = ENOSYS;
    return -1;
#endif
}

/**
 * @} end pthread group
 */
