/*
*********************************************************************************************************
*                  Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS, VehicleOS
*                                            for STM32Cube
*
*                           (c) Copyright 2007 - 2018; RoweBots Research Inc.
*                                           www.rowebots.com
*********************************************************************************************************
* Licensing:
*          YOUR USE OF THIS SOFTWARE IS SUBJECT TO THE TERMS OF A ROWEBOTS SOFTWARE LICENSE.
* 1. If you are not willing to accept the terms of an appropriate RoweBots Software License, you must
*    not download or use this software for any reason.
* 2. Information about RoweBots licensing regarding this software available at
*    www.rowebots.com/products/licensing/st-v1.
* 3. It is your obligation to select an appropriate license based on your intended use of the
*    Unison OS, Unison RTOS, WearableOS, MedicalOS, ConsumerOS or VehicleOS.
* 4. Unless you have executed a RoweBots Source Code License Agreement, your use of the RoweBots OS
*    offering is limited to evaluation, educational or personal non-commercial uses.
* 5. If you use this software package with RoweBots OS components for STMicroelectronics MCU/MPU, you
*    must still execute a RoweBots Source Code License Agreement and abide by the terms of this License
*    with the caveat that fees for commercial use are waived for those components.
* 6. The Unison OS and its' variants may not be redistributed or disclosed to any third party without
*    the written consent of RoweBots Research Inc. Only STMicroelectronics can redistribute this source
*    code, in case it would be reused in one package, through the SLA0048 license: www.st.com/SLA0048.
*********************************************************************************************************
* Documentation and Working Examples:
*    You can find user manuals, API references and more at www.rowebots.com. All provided source code
*    examples are in ready to run state.
*********************************************************************************************************
* Technical Support:
*    Support is available for all users of RoweBots software. For additional information on support, see
*    www.rowebots.com/support or you can contact support@rowebots.com.
*********************************************************************************************************
*/

#ifndef _port_h_
#define _port_h_


/*
 * Define CPU core. The following Cortex-M cores are supported:
 *   - Cortex-M0/M0+:      __ARMCORTEXM0__
 *   - Cortex-M3:          __ARMCORTEXM3__
 *   - Cortex-M4:          __ARMCORTEXM4__
 *   - Cortex-M4 with FPU: __ARMCORTEXM4F__
 *   - Cortex-M7:          __ARMCORTEXM7__
 */
//#define __ARMCORTEXM7__        // defined in project settings for preprocessor


/*
 * These are parameters for Cortex-M series
 */
#if defined(__ARMCORTEXM0__) || defined(__ARMCORTEXM3__) || defined(__ARMCORTEXM4__)
    #define PLATFORM_STACK_MIN       112            // 92 bytes for context + 20 additional bytes
    #define PLATFORM_STACK_DEFAULT   412            // add 300 bytes to minimal stack

#elif defined(__ARMCORTEXM4F__) || defined(__ARMCORTEXM7__)
    #define PLATFORM_STACK_MIN       240            // 220 bytes for context + 20 additional bytes
    #define PLATFORM_STACK_DEFAULT   540            // add 300 bytes to minimal stack

#else
    #error You must define the stack parameters for this port!
#endif


/*
 * Redefine Unison's system functions to Cortex-M interrupts names
 */
#define StartFirstTask_Handler  SVC_Handler
#define TaskSwitch_Handler      PendSV_Handler



#endif /* _port_h_ */
